<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class LeadActivitySeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        $activityTypes = ['call', 'email', 'meeting', 'note', 'whatsapp'];

        // Fetch all lead IDs
        $leads = DB::table('leads')->select('id')->get();

        foreach ($leads as $lead) {
            $activityCount = rand(1, 4); // Each lead gets 1–4 activities

            for ($i = 0; $i < $activityCount; $i++) {
                $followedUpAt = $faker->dateTimeBetween('2024-01-01', 'now');
                $nextFollowUp = rand(0, 1) ? $faker->dateTimeBetween($followedUpAt, '+2 months') : null;

                DB::table('lead_activities')->insert([
                    'lead_id' => $lead->id,
                    'activity_type' => $faker->randomElement($activityTypes),
                    'description' => $faker->sentence,
                    'next_follow_up_at' => $nextFollowUp,
                    'followed_up_at' => $followedUpAt,
                    'created_by' => 1,
                    'created_at' => now(),
                    'updated_at' => now(),
                    'deleted_at' => null,
                ]);
            }
        }
    }
}
